VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsLastseen"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Lastseen()   As LSD
Private Type LSD
    Username        As String
    Filetime        As Long 'Provides both date AND time.
    Channel         As String
    Server          As String
    Product         As String
    Latency         As Long
    Flags           As Long
End Type

Public Enum SEARCHMETHOD
    User = 1
    Channel = 2
    Server = 3
End Enum

Private Sub Class_Initialize()
    ReDim Lastseen(0)
End Sub

Private Sub Class_Terminate()
    ReDim Lastseen(0)
End Sub

Public Sub addLastSeen(ByRef Username As String, ByRef Channel As String, ByRef Product As String, ByRef Latency As Long, ByRef Flags As Long, ByRef Server As String, Optional ByRef Filetime As Long)
    Dim Index As Integer
    
    'In case they are invalid results
    If (Username = vbNullString) Then Username = StrReverse$("<n/a>") 'Products are stored reverse, this is so the class parses it correctly.
    If (Channel = vbNullString) Then Channel = StrReverse$("<n/a>")
    If (Product = vbNullString) Then Product = StrReverse$("<n/a>")
    If (Server = vbNullString) Then Server = StrReverse$("<n/a>")
    
    'Store only 150 entries, if above remove the first index
    If (UBound(Lastseen) > 150) Then removeLastSeen (0)
    
    If (Username <> vbNullString) Then
        Index = indexLastSeen(Username)
        If (Index = -1) Then 'Not in the databsae
            With Lastseen(UBound(Lastseen))
                .Username = Username
                'Only for reloading
                If (Filetime = 0) Then
                    .Filetime = modFileTime.Get_FILETIME
                Else
                    .Filetime = Filetime
                End If
                .Channel = Channel
                .Server = Server
                .Product = Product
                .Latency = Latency
                .Flags = Flags
            End With
            ReDim Preserve Lastseen(UBound(Lastseen) + 1)
        ElseIf (Index < UBound(Lastseen)) Then ' In the database
            With Lastseen(Index)
                .Username = Username
                'Only for reloading
                If (Filetime = 0) Then
                    .Filetime = modFileTime.Get_FILETIME
                Else
                    .Filetime = Filetime
                End If
                .Channel = Channel
                .Server = Server
                If (Product <> vbNullString) Then .Product = Product
                .Latency = Latency
                .Flags = Flags
            End With
        End If
    End If
End Sub

Private Sub removeLastSeen(ByRef Index As Integer)
    Dim i As Integer
    If (Index > -1 And Index < UBound(Lastseen)) Then
        For i = Index To UBound(Lastseen) - 1
            Lastseen(i) = Lastseen(i + 1)
        Next i
        ReDim Preserve Lastseen(UBound(Lastseen) - 1)
    End If
End Sub

Private Function indexLastSeen(ByRef Username As String, Optional ByRef Wildcard As Boolean) As Integer
    Dim i As Integer
    If (Username <> vbNullString) Then
        For i = 0 To UBound(Lastseen) - 1
            If (Wildcard) Then
            
            Else
                If (StrComp(Username, Lastseen(i).Username, vbTextCompare) = 0) Then
                    indexLastSeen = i
                    Exit Function
                End If
            End If
        Next i
    End If
    indexLastSeen = -1
End Function

Public Function dumpLastSeenDatabase(ByRef Index As Integer)
    Dim i As Integer
    'Structure:
    '(DWORD)    Profile Amount
    '
    '(STRING)   Profile Name
    '(DWORD)    Amount
    '(STRING)   Username
    '(STRING)   Channel
    '(STRING)   Product
    '(STRING)   Server
    '(DWORD)    FILETIME
    '(DWORD)    Latency
    '(DWORD)    Flags
    With PktBuffer
        .InsertNTString Bots(Index).Profile
        .InsertDWORD UBound(Lastseen)
        For i = 0 To UBound(Lastseen) - 1
            .InsertNTString Lastseen(i).Username
            .InsertNTString Lastseen(i).Channel
            .InsertNTString Lastseen(i).Product
            .InsertNTString Lastseen(i).Server
            .InsertDWORD Lastseen(i).Filetime
            .InsertDWORD Lastseen(i).Latency
            .InsertDWORD Lastseen(i).Flags
        Next i
    End With
End Function

Public Sub addToListView(ByRef lvLastseen As ListView, ByRef Index As Integer, ByVal LastSeenBotIndex As Integer)
    Dim i As Integer
    'Columns: Username - Date - Time
    If (Index > -1 And Index < UBound(Lastseen)) Then
        With lvLastseen
            'Set the filetime to system time to be able to use it.
            Call Set_SYSTEMTIME(Lastseen(Index).Filetime)
            'Add -> username
            .ListItems.Add .ListItems.Count + 1, , Lastseen(Index).Username
            'Add -> date
            .ListItems((.ListItems.Count)).ListSubItems.Add , , Get_Date()
            'Add -> time
            .ListItems((.ListItems.Count)).ListSubItems.Add , , Get_Time()
            
            'Set tag for tooltip
            .ListItems((.ListItems.Count)).Tag = "Profile: " & Bots(LastSeenBotIndex).Profile _
                & vbNewLine & "Channel: " & Lastseen(Index).Channel _
                & vbNewLine & "Server: " & Lastseen(Index).Server _
                & vbNewLine & "Product: " & StrReverse$(Lastseen(Index).Product) _
                & vbNewLine & "Latency: " & Lastseen(Index).Latency & "ms" _
                & vbNewLine & "Flags: " & "0x0" & Hex(Lastseen(Index).Flags)
        End With
    End If
End Sub

'This is dependent upon other classes and functions, sorry =\, it was way to much work to do it otherwise.
Public Sub addToListViewProfile(ByRef lvLastseen As ListView, ByRef Index As Integer)
    Dim i As Integer
    'Columns: Username - Date - Time
    If (Index > -1 And Index < UBound(Bots)) Then
        With lvLastseen
            For i = 0 To UBound(Lastseen) - 1
                'Set the filetime to system time to be able to use it.
                Call Set_SYSTEMTIME(Lastseen(i).Filetime)
                'Add -> username
                .ListItems.Add (i + 1), , Lastseen(i).Username
                'Add -> date
                .ListItems((i + 1)).ListSubItems.Add , , Get_Date()
                'Add -> time
                .ListItems((i + 1)).ListSubItems.Add , , Get_Time()
                
                'Set tag for tooltip
                .ListItems((i + 1)).Tag = "Profile: " & Bots(Index).Profile _
                    & vbNewLine & "Channel: " & Lastseen(i).Channel _
                    & vbNewLine & "Server: " & Lastseen(i).Server _
                    & vbNewLine & "Product: " & StrReverse$(Lastseen(i).Product) _
                    & vbNewLine & "Latency: " & Lastseen(i).Latency & "ms" _
                    & vbNewLine & "Flags: " & "0x0" & Hex(Lastseen(i).Flags)
                    
            Next i
        End With
    End If
End Sub

Public Sub searchLastSeen(ByRef ListView As ListView, ByRef SearchType As SEARCHMETHOD, ByRef SearchString As String, ByRef LastSeenBotIndex As Integer)
    Dim i As Integer
    
    Select Case SearchType
        Case SEARCHMETHOD.Channel
            For i = 0 To UBound(Lastseen) - 1
                If (Wildcard(Lastseen(i).Channel, SearchString)) Then
                    Call addToListView(ListView, i, LastSeenBotIndex)
                End If
            Next i
        Case SEARCHMETHOD.Server
            For i = 0 To UBound(Lastseen) - 1
                If (Wildcard(Lastseen(i).Server, SearchString)) Then
                    Call addToListView(ListView, i, LastSeenBotIndex)
                End If
            Next i
        Case SEARCHMETHOD.User
            For i = 0 To UBound(Lastseen) - 1
                If (Wildcard(Lastseen(i).Username, SearchString)) Then
                    Call addToListView(ListView, i, LastSeenBotIndex)
                End If
            Next i
    End Select
End Sub


